@ECHO OFF
REM Copyright Intel Corporation 2004-2011
REM Version 1.1
REM Function summary:
REM    This batch file helps install the driver needed for the tools to run
REM ------------------------------------------------------------------

REM Check if a iqvw64.sys already exists in the install directory that
REM the installation will get the file.
if exist .\iqvw64.sys GOTO instfileexists
ECHO ivwv64.sys file not found in installation directory.
ECHO Please make sure that iqvw64.sys exists in the same
ECHO directory as install.bat
GOTO exit

:instfileexists
REM Check if a iqvw64.sys already exists in the Windows install directory
echo Welcome to the Tools driver installation program.
echo After installation of the driver (iqvw64.sys), the tool can be invoked.
echo -----------------------------------------------------------------------
echo Checking to see if iqvw64.sys exists on system
if exist %systemroot%\system32\drivers\iqvw64.sys GOTO chkexten
GOTO clninst

:chkexten
REM Check to see if /y extension is enabled
if "%1" == "/y" GOTO extenbl
GOTO options

:extenbl
echo /y extension is enabled!
GOTO copysys

:options
REM iqvw64.sys file existence has been confirmed
REM Time to tell the user the options
echo ----------------------------------------------------------------------
echo An iqvw64.sys file is already present on your system.
echo By overwriting this file (it exists in %systemroot%\system32\drivers)
echo there is a potential of blue-screens in PROSet and/or other tools
echo that already EXIST on the system.
echo *  If PROSet is installed, please uninstall PROSet and perform
echo    this setup again.  Please note, by re-installing PROSet later on,
echo    PROSet could render this tool useless and will require
echo    running install.bat again to make the tool work.
echo *  If PROSet not installed, this file could be used by another
echo    corresponding tool.  This may cause a blue-screen or failure in
echo    existing tools using the old iqvw64.sys file, so you may want to
echo    rename the file for backup reasons.  If you want to overwrite
echo    iqvw64.sys, please re-run the installation with a /y extension
echo    (install.bat /y).
echo ----------------------------------------------------------------------
echo.
goto exit

:clninst
REM This path is taken when an iqvw64.sys file does not exist on the system
echo No existing iqvw64.sys file exists
GOTO copysys

:copysys
REM This copies the file whether or not something exist.
echo Copying iqvw64.sys file to %systemroot%\system32\drivers
copy iqvw64.sys %systemroot%\system32\drivers /y
echo Installation done!  You can now invoke the tool.  To exit,
GOTO end

:exit
REM Exit point for a aborted install
cls
echo Aborting installation because driver already exists. Run install /y to override!
echo To Exit,
:end
